// ====================================================================

// 1.  Find ROCKEY2 dongles attached to the computer
EXTERN_C int WINAPI RY2_Find();
//return value
// <0	Error code
// =0	No ROCKEY2 dongle is attached
// >0	The number of attached ROCKEY2 dongle(s) 

// ====================================================================

// 2. Open specified ROCKEY2 dongle
EXTERN_C int WINAPI RY2_Open(int mode, DWORD uid, DWORD* hid);
// input:
// mode----This parameter indicates the way to open the dongle
// mode = 0, open the first found ROCKEY2 dongle
// mode > 0, open the dongle according to the UID. The mode value is the dongle number, 
//           for example: uid=12345678, mode=2, this means it will open the second dongle with UID 12345678
// mode = -1, open the dongle according to the HID, and *hid can not be 0
//We defined two MACROs: 
#define AUTO_MODE	0
#define HID_MODE	-1
// uid---UserID,You need to specify the dongle UID and this UID is generated with RY2_GenUID
// hid---Hardware ID,Open dongle with HID of *hid
// The dongle HID will be returned to *hid regardless of how the dongle was opened.
// return vaule:
// >=0	Success. The opened dongle handle is returned.
// < 0	Error code. Please refer to the later

// ====================================================================

// 3. Close specified ROCKEY2 dongle
EXTERN_C void WINAPI RY2_Close(int handle);
// Input:
// handle---ROCKEY2 dongle handle. It is the handle returned from RY2_Open 
// Return:
// Error code. Please refer to the later

// ====================================================================

// 4.Generate User ID(UID)
EXTERN_C int WINAPI RY2_GenUID(int handle, DWORD* uid, char* seed, int isProtect);
// input:
// handle---Dongle handle. It is the handle returned from RY2_Open.
// uid---Output parameter. The generated UID.
// seed---Seed to generate UID. It is a character string with the maximum length of 64 bytes
// isProtect---Sets write protection. 0=dongle not write protected, 1=dongle write protected.
#define ROCKEY2_DISABLE_WRITE_PROTECT	0
#define ROCKEY2_ENSABLE_WRITE_PROTECT	1
// Return:
// Error code. Please refer to the later

// ====================================================================

// 5. Read dongle content
EXTERN_C int WINAPI RY2_Read(int handle, int block_index, char* buffer512);
// input:
// handle---Dongle handle. It is the handle returned from RY2_Open.
// block_index---Block index. Specify the block to read. The value range is 0-4.
// buffer512---Read buffer. The buffer must be at least 512 bytes to accommodate the 512 byte block size.
// Return:
// Error code. Please refer to the later

// ====================================================================

// 6. Write to ROCKEY2 dongle
EXTERN_C int WINAPI RY2_Write(int handle, int block_index, char* buffer512);
// input:
// handle---Dongle handle. It is the handle returned from RY2_Open 
// block_index---Block index. Specify the block to read. The value range is 0-4.
// buffer512---Read buffer. The buffer must be at least 512 bytes to accommodate the 512 byte block size.
// Return:
// Error code. Please refer to the later


// Error code ===========================================================

// Success
#define RY2ERR_SUCCESS									0

// Specified dongle is not found (parameter error)
#define RY2ERR_NO_SUCH_DEVICE							0xA0100001

// Need to call RY2_Open first to open the dongle, then call this function (operation error)
#define RY2ERR_NOT_OPENED_DEVICE						0xA0100002

//Wrong UID(parameter error)
#define RY2ERR_WRONG_UID								0xA0100003

// Block index error (parameter error)
#define RY2ERR_WRONG_INDEX								0xA0100004

// Seed character string is longer than 64 bytes when calling GenUID (parameter error)
#define RY2ERR_TOO_LONG_SEED							0xA0100005

// Tried to write to write-protected dongle(operation error)
#define RY2ERR_WRITE_PROTECT							0xA0100006

// Open device error (Windows error)
#define RY2ERR_OPEN_DEVICE								0xA0100007

// Read record error(Windows error)
#define RY2ERR_READ_REPORT								0xA0100008

// Write record error(Windows error)
#define RY2ERR_WRITE_REPORT								0xA0100009

// Internal error (Windows error)
#define RY2ERR_SETUP_DI_GET_DEVICE_INTERFACE_DETAIL		0xA010000A

//Internal error (Windows error)
#define RY2ERR_GET_ATTRIBUTES							0xA010000B

// Internal error (Windows error)
#define RY2ERR_GET_PREPARSED_DATA						0xA010000C

// Internal error (Windows error)
#define RY2ERR_GETCAPS									0xA010000D

// Internal error (Windows error)
#define RY2ERR_FREE_PREPARSED_DATA						0xA010000E

// Internal error (Windows error)
#define RY2ERR_FLUSH_QUEUE								0xA010000F

//Internal error (Windows error)
#define RY2ERR_SETUP_DI_CLASS_DEVS						0xA0100010

//Internal error (Windows error)
#define RY2ERR_GET_SERIAL								0xA0100011

//Internal error (Windows error)
#define RY2ERR_GET_PRODUCT_STRING						0xA0100012

// Internal error
#define RY2ERR_TOO_LONG_DEVICE_DETAIL					0xA0100013

//Unknown device(hardware error)
#define RY2ERR_UNKNOWN_DEVICE							0xA0100020

//Verification error(hardware error)
#define RY2ERR_VERIFY									0xA0100021

// Unknown error(hardware error)
#define RY2ERR_UNKNOWN_ERROR							0xA010FFFF
